from datetime import datetime
from functools import singledispatch
from numbers import Real


@singledispatch
def report(value):
    return f"Bez określania typu: {value}"


@report.register
def _(value: datetime):
    return f"Obiekt datetime: {value.isoformat()}"


@report.register
def _(value: complex):
    return f"Liczba zespolona: {value.real}{value.imag:+}j"


@report.register
def _(value: Real):
    return f"Liczba rzeczywista: {value:f}"


if __name__ == "__main__":
    print(report(datetime.now()))
    print(report(100 - 30j))
    print(report("Styczeń"))
    for key, value in report.registry.items():
        print(f"{key} -> {value}")
